-- On se place dans le contexte de la base master
USE master;
GO
-- On cre un compte de connexion nomm CNX_SQLDEV
CREATE LOGIN CNX_SQLDEV WITH PASSWORD = 'Ada LOVELACE';
GO
-- On se place dans le contexte de la base DB_MAGIC
USE DB_MAGIC;
GO
-- On cre un utilisateur nomm USR_SQLDEV li  la connexion CNX_SQLDEV
CREATE USER USR_SQLDEV FROM LOGIN CNX_SQLDEV;
GO
-- On cre un rle nomm ROL_SQLDEV
CREATE ROLE ROL_SQLDEV;
GO
-- On octroie  ce rle diffrents privilges
GRANT CREATE ASSEMBLY, CREATE AGGREGATE, CREATE FUNCTION,
CREATE PROCEDURE, SELECT, SHOWPLAN, VIEW DEFINITION
ON DATABASE::DB_MAGIC TO ROL_SQLDEV;
GO
-- On affecte ce rle aux utilisateurs USR_SQLDEV et USR_ADMIN
ALTER ROLE ROL_SQLDEV ADD MEMBER USR_SQLDEV;
ALTER ROLE ROL_SQLDEV ADD MEMBER USR_ADMIN;
GO
-- Pour les versions 2005 et 2008 [R2], on aurait crit:
EXEC master..sp_addrolemember 'ROL_SQLDEV', 'USR_SQLDEV';
EXEC master..sp_addrolemember 'ROL_SQLDEV', 'USR_ADMIN';